

export class CustomerListWidget {

	ezTpl = null;
	
	loadCustomerAbortController = null;
	
	selectionMode = false;
	selectionCallback = null;
	
	pageNo = 0;
	q = '';
	
	
	selectedCustomerId = null;
	
	tpl = `
	<div class="customer-list-widget">
		<div class="page-header" ez-if="selectionMode == false">
			<div class="toolbox">
				<a href="{{appUrl('/customers/edit/')}}" class="fa fa-plus"></a>
			</div>
			<h1>Relaties</h1>
		</div>
		
		<input class="top-q" type="text" name="q" autocomplete="off" placeholder="Klantnaam, contactpersoon, ..." />
		
		<div ez-subtemplate="customerlist">
			<div ez-if="customers == null">
				Loading...
			</div>
			<div ez-if="customers != null">
			
				<table class="table">
					<thead>
						<tr>
							<th style="width: 100px;">Type</th>
							<th>Naam</th>
							<th>Contactpersoon</th>
							<th style="width: 200px;"></th>
						</tr>
					</thead>
					<tbody ez-for="customers" ez-item="c">
						<tr [onclick]="widget.customerRow_Click" class="pointer {{c.customerId == selectedCustomerId ? 'selected' : ''}}">
							<td customer-id="{{c.customerId}}">
								{{_('customer_type.'+c.customerType)}}
							</td>
							<td>
								{{c.customerName ?? ''}}
							</td>
							<td>
								{{c.contactPerson ?? ''}}
							</td>
							<td class="actions">
								<a ez-if="selectionMode == false" href="{{appUrl('/customers/edit/?id='+c.customerId)}}" class="fa fa-pencil"></a>
							</td>
						</tr>
					</tbody>
						<tr ez-if="customers.length == 0">
							<td colspan="4" class="no-results">Geen resultaten gevonden</td>
						</tr>
				</table>
				
				<ez-pager></ez-pager>
				
			</div>
		</div>
	</div>
	`;
	
	keyupTimeout = null;
	
	
	setSelectionCallback(func) {
		this.selectionMode = true;
		this.selectionCallback = func;
	}
	
	
	setSelectedCustomerId( customerId ) {
		this.selectedCustomerId = customerId;
	}
	
	customerRow_Click(evt, tr) {
		let uid = tr.querySelector('[customer-id]').getAttribute('customer-id');
		
		if (this.selectionMode) {
			this.selectionCallback( uid );
		}
		else {
			gotoRoute( '/customers/edit/?id='+uid );
		}
	}
	
	loadCustomers( opts ) {
		opts = opts ?? {};
		
		if (this.loadCustomerAbortController != null) {
			this.loadCustomerAbortController.abort();
		}
		
		this.loadCustomerAbortController = new AbortController();
		let data = {};
		data.q = this.q;
		data.pageNo = this.pageNo;
		
		if ($.trim(this.q) == '' && this.selectedCustomerId) {
			data.selectedCustomerId = this.selectedCustomerId;
		}
		
		postUrl('/service/customers.do'
			, data
			, {
				signal: this.loadCustomerAbortController.signal
			}
		)
		.then(async function(data) {
			let resp = await data.json();
			
			console.log( resp );
			
			if (resp.error) {
				showErrorWidget( resp );
			}
			
			
			let eztpl = $('[ez-subtemplate=customerlist]').get(0).eztemplate;
			
//			eztpl.setObject('widget', this);
			eztpl.setVar('customers', resp.customers);
			eztpl.setVar('selectedCustomerId', this.selectedCustomerId);
			eztpl.setVar('response', resp);
			
			eztpl.render();
		}.bind(this))
		.catch( showErrorWidget )
	}
	
	
	
	init(e) {
		this.ezTpl = new EzTemplate( e );
		this.ezTpl.setVar('customers', null);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.setVar('selectionMode', this.selectionMode);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
		$('.top-q').focus();
		
		this.q = getUrlParam('q') ?? '';
		this.pageNo = getUrlParam('pageNo') ?? 0;
		
		this.loadCustomers( );
		
		$(e).find('.top-q').val( this.q );
		
		let clw = this;
		
		// auto load on keyup
		$(e).find('.top-q').on('keyup', function(evt) {
			// enter => skip.. handled by 'change'
			if (evt.keyCode == 13) {
				return;
			}
			if (this.keyupTimeout != null) {
				clearTimeout( this.keyupTimeout );
			}
			
			// no change?
			if ($(evt.target).val() == clw.q) return;
			
			this.keyupTimeout = setTimeout(function() {
				let q = $(evt.currentTarget).val();
				q = $.trim(q);
				
				if (this.selectionMode) {
					this.q = q;
					this.pageNo = 0;
					this.loadCustomers();
				}
				else {
					this.newSearch( q );
				}			
			}.bind(this), 200 );
		}.bind(this));
		
		// change = enter hit
		$(e).find('.top-q').on('change', function(evt) {
			if (this.keyupTimeout != null) {
				clearTimeout( this.keyupTimeout );
			}
			
			let q = $(evt.currentTarget).val();
			q = $.trim(q);
			
			if (this.selectionMode) {
				this.q = q;
				this.pageNo = 0;
				this.loadCustomers();
			}
			else {
				this.newSearch( q );
			}
		}.bind(this));
	}
	
	newSearch( q ) {
		this.q = q;
		this.pageNo = 0;
		window.history.replaceState({}, null, appUrl('/customers/' + '?q=' + encodeURIComponent(q)));
		this.loadCustomers();
	}
	
	
	selectPage( pageNo ) {
		if (this.selectionMode) {
			this.pageNo = pageNo;
			this.loadCustomers();
		}
		else {
			gotoRoute( '/customers/' + '?pageNo=' + pageNo + '&q=' + encodeURIComponent(this.q) );
		}
	}
	
}

